      subroutine rcritval(dalpha,ilag,dv)
c**********************************************************************
c
c  Double precision FORTRAN subroutine for returning the appropriate
c  critical value for the R statistic for nominal level of significance
c  dalpha and lag = lag.
c
c  Input: dalpha = a double precision real scalar containing the 
c                  level of significance of the test.
c         ilag = an integer scalar containing the lag in the test.
c
c  Output: dv = a double precision scalar containing the critical
c               value of the R test statistic for rejecting the null 
c               hypothesis of independence. 
c 
c
c  Subprograms called: none.
c
c  Written: 2/2/99 JLH
c  Modified: 2/10/99 JLH
c
c  Notes: Critical values found from simulation which applied the 
c         test to 1000 replications of white noise series of length 
c         n = 300.
c
c**********************************************************************
c
	integer ilag
	double precision dalpha,dv,diff1,diff2,diff3,deps
	data deps/1.0d-06/ 
c
	dv    = 0.0d0
	diff1 = dabs(dalpha - 0.10d0)
	diff2 = dabs(dalpha - 0.05d0)
	diff3 = dabs(dalpha - 0.01d0)
	if(diff1.lt.deps) then
		if(ilag.eq.1) dv = 0.21800d0
		if(ilag.eq.2) dv = 0.21771d0
		if(ilag.eq.3) dv = 0.21832d0
		if(ilag.eq.4) dv = 0.21870d0
		if(ilag.eq.5) dv = 0.21510d0
	elseif(diff2.lt.deps) then
		if(ilag.eq.1) dv = 0.22712d0
		if(ilag.eq.2) dv = 0.22520d0
		if(ilag.eq.3) dv = 0.22780d0
		if(ilag.eq.4) dv = 0.22750d0
		if(ilag.eq.5) dv = 0.22170d0
	elseif(diff3.lt.deps) then
		if(ilag.eq.1) dv = 0.24341d0
		if(ilag.eq.2) dv = 0.23920d0
		if(ilag.eq.3) dv = 0.24490d0
		if(ilag.eq.4) dv = 0.24261d0
		if(ilag.eq.5) dv = 0.23820d0
	endif
c     
	return
	end
